#
#  Media Center Master Plex T.V. scanner
#
#  Custom utilities
#
#  Portions of the code used by this scanner was provided by:
#      http://forums.plexapp.com/index.php/topic/53368-custom-plex-scanners/
#
#  Which is a patched version of the original Plex series scanner that is
#  copyrighted (c) 2010 by the Plex Development Team (all rights reserved).
#
#  Parts of this code are by copyrighted by Media Center Master:
#      (C) 2013-2018 Media Center Master, Inc.
#      All rights reserved.
#      http://www.MediaCenterMaster.com/
#
#  Additional credits to:
#      Guillaume Boudreau
#          modified to ignore folders containing .plexignore marker files
#
#  Version 1.00     2013-02-11
#  Version 1.6      2018-02-28     formatted for PEP8 compliance
#                                  http://www.pep8online.com/
#


import os.path


# Ignore folders containing .plexignore marker files
def Ignore(subdirs):
    subdirs_to_whack = []
    for subdir in subdirs:
        if os.path.exists(subdir + '/.plexignore'):
            print "Found .plexignore file in " + subdir + ". Ignoring."
            subdirs_to_whack.append(subdir)

    # Whack subdirs.
    subdirs_to_whack = list(set(subdirs_to_whack))
    for subdir in subdirs_to_whack:
        subdirs.remove(subdir)
